<?php
// /panel/_ping.php - diagnóstico directo
header('Content-Type: text/plain; charset=utf-8');
error_reporting(E_ALL); ini_set('display_errors','1');

require_once __DIR__.'/config.php';

echo "PHP: ".PHP_VERSION."\n";
echo "pdo: ".(extension_loaded('pdo')?'OK':'MISSING')."\n";
echo "pdo_mysql: ".(extension_loaded('pdo_mysql')?'OK':'MISSING')."\n";
echo "DB_HOST=".DB_HOST." DB_NAME=".DB_NAME." DB_USER=".DB_USER."\n";

function try_pdo($host){
  try{
    $pdo=new PDO('mysql:host='.$host.';dbname='.DB_NAME.';charset=utf8mb4', DB_USER, DB_PASS,[
      PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC,
    ]); return $pdo;
  }catch(Throwable $e){ echo "FAIL host=".$host.": ".$e->getMessage()."\n"; return null; }
}

$pdo=try_pdo(DB_HOST);
if(!$pdo && DB_HOST==='localhost') $pdo=try_pdo('127.0.0.1');
if(!$pdo){ echo "NO CONNECT. Revisa nombre de BD/usuario exactos (con prefijo de cPanel).\n"; exit; }

echo "MySQL CONNECT OK\n";
try{
  $r=$pdo->query("SHOW TABLES LIKE 'nova_units'")->fetchColumn();
  echo "nova_units: ".($r?'EXISTS':'NO')."\n";
}catch(Throwable $e){ echo "nova_units check error: ".$e->getMessage()."\n"; }

$panelTables=['nmc_centers','nmc_units','nmc_customers','nmc_reservations'];
foreach($panelTables as $t){
  try{ $pdo->query("SELECT 1 FROM $t LIMIT 1"); echo "$t: OK\n"; }
  catch(Throwable $e){ echo "$t: NO (".$e->getMessage().")\n"; }
}
